﻿<%@ import Namespace="Soneta.Tools" %>
<%@ import Namespace="Soneta.Types" %>
<%@ import Namespace="Soneta.Business" %>
<%@ import Namespace="Soneta.Kadry" %>
<%@ Register TagPrefix="ea" Namespace="Soneta.Web" Assembly="Soneta.Web" %>
<%@ Register TagPrefix="eb" Namespace="Soneta.Core.Web" Assembly="Soneta.Core.Web" %>
<%@ Page language="c#" AutoEventWireup="false" codePage="1200" %>
<!DOCTYPE HTML PUBLIC "-//W3C//DTD HTML 4.0 Transitional//EN" >

<script runat="server">

    [DefaultWidth(15)]
    public enum FiltrRachunki {
        Aktywne, Zablokowane, Wszystkie
    }

    public class PrnParams : ContextBase {

        public PrnParams(Context context)
            : base(context) {
        }

        FiltrRachunki filtr = FiltrRachunki.Aktywne;
        [Caption("Rachunki")]
        [Priority(10)]
        public FiltrRachunki Filtr {
            get { return filtr; }
            set {
                filtr = value;
                OnChanged(EventArgs.Empty);
            }
        }
    }

    FiltrRachunki filtr;
    [Context]
    public PrnParams Params {
        set { filtr = value.Filtr; }
    }
    
    protected void dc_ContextLoad(object sender, EventArgs e) {

    }
    
    protected void Grid_BeforeRow(object sender, RowEventArgs args) {
        Pracownik pracownik = (Pracownik)args.Row;
        bool any = false;
        foreach (RachunekBankowyPracownika rachunek in pracownik.Rachunki) {
            switch (filtr) {
                case FiltrRachunki.Aktywne:
                    if (rachunek.Blokada) continue;
                    break;
                case FiltrRachunki.Zablokowane:
                    if (!rachunek.Blokada) continue;
                    break;
            }

            string numer = rachunek.Rachunek.Numer.Pełny.Trim();
            colRachunki.AddLine(numer=="" ? "&nbsp;" : numer);
            any = true;
        }
        if (!any)
            args.VisibleRow = false;      
    }

</script>

<HTML>
	<HEAD>
		<TITLE>Konta bankowe pracowników</TITLE>
		<META content="C#" name="CODE_LANGUAGE">
		<META content="JavaScript" name="vs_defaultClientScript">
		<META content="http://schemas.microsoft.com/intellisense/ie5" name="vs_targetSchema">
	</HEAD>
	<BODY>
		<FORM method="post" runat="server">
			<ea:DataContext id="dc" runat="server" oncontextload="dc_ContextLoad"></ea:DataContext>
			<eb:ReportHeader NagłówekOddziału="NagłówekOddziału" id="ReportHeader" runat="server" title="Konta bankowe pracowników|Wydział: {0}|Pośrednio: {1}|Okres: {2}|Aktualny: {3}" DataMember0="WdzParams.Wydział" DataMember1="WdzParams.Pośrednio" DataMember2="WdzParams.Okres" DataMember3="WdzParams.Aktualny"></eb:ReportHeader>
			<ea:Grid id="Grid" runat="server" 
                RowTypeName="Soneta.Kadry.Pracownik,Soneta.KadryPlace" 
                onbeforerow="Grid_BeforeRow">
				<Columns>
					<ea:GridColumn Width="4" Align="Right" DataMember="#" Caption="LP."></ea:GridColumn>
					<ea:GridColumn runat="server" Align="Left" DataMember="Pracownik" 
                        Caption="Pracownik" VAlign="Top"></ea:GridColumn>
					<ea:GridColumn runat="server" Align="Left" EncodeHTML="True"
                        DataMember="Workers.Info.Historia.Etat.Wydzial.Kod" Caption="Wydział" 
                        Width="22" VAlign="Top"></ea:GridColumn>
					<ea:GridColumn ID="colRachunki" runat="server" Caption="Rachunki">
                    </ea:GridColumn>
				</Columns>
			</ea:Grid>
			<eb:ReportFooter id="ReportFooter" runat="server"></eb:ReportFooter>
		</FORM>
	</BODY>
</HTML>

